/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.gadgets;

import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.forge.event.lifecycle.GatherDataEvent;
import net.minecraftforge.registries.RegistryObject;
import org.apache.logging.log4j.Logger;
import slimeknights.mantle.item.BlockTooltipItem;
import slimeknights.mantle.registration.object.EnumObject;
import slimeknights.mantle.registration.object.ItemObject;
import slimeknights.mantle.util.SupplierCreativeTab;
import slimeknights.tconstruct.common.TinkerModule;
import slimeknights.tconstruct.gadgets.block.FoodCakeBlock;
import slimeknights.tconstruct.gadgets.block.PunjiBlock;
import slimeknights.tconstruct.gadgets.capability.PiggybackCapability;
import slimeknights.tconstruct.gadgets.data.GadgetRecipeProvider;
import slimeknights.tconstruct.gadgets.entity.EflnBallEntity;
import slimeknights.tconstruct.gadgets.entity.FancyItemFrameEntity;
import slimeknights.tconstruct.gadgets.entity.FrameType;
import slimeknights.tconstruct.gadgets.entity.GlowballEntity;
import slimeknights.tconstruct.gadgets.entity.shuriken.FlintShurikenEntity;
import slimeknights.tconstruct.gadgets.entity.shuriken.QuartzShurikenEntity;
import slimeknights.tconstruct.gadgets.item.EflnBallItem;
import slimeknights.tconstruct.gadgets.item.FancyItemFrameItem;
import slimeknights.tconstruct.gadgets.item.GlowBallItem;
import slimeknights.tconstruct.gadgets.item.PiggyBackPackItem;
import slimeknights.tconstruct.gadgets.item.ShurikenItem;
import slimeknights.tconstruct.gadgets.item.slimesling.BaseSlimeSlingItem;
import slimeknights.tconstruct.gadgets.item.slimesling.EarthSlimeSlingItem;
import slimeknights.tconstruct.gadgets.item.slimesling.EnderSlimeSlingItem;
import slimeknights.tconstruct.gadgets.item.slimesling.IchorSlimeSlingItem;
import slimeknights.tconstruct.gadgets.item.slimesling.SkySlimeSlingItem;
import slimeknights.tconstruct.library.utils.Util;
import slimeknights.tconstruct.shared.TinkerFood;
import slimeknights.tconstruct.shared.block.SlimeType;

public final class TinkerGadgets
extends TinkerModule {
    public static final CreativeModeTab TAB_GADGETS = new SupplierCreativeTab("tconstruct", "gadgets", () -> new ItemStack((ItemLike)slimeSling.get((Enum)SlimeType.EARTH)));
    static final Logger log = Util.getLogger("tinker_gadgets");
    private static final Item.Properties GADGET_PROPS = new Item.Properties().m_41491_(TAB_GADGETS);
    private static final Item.Properties UNSTACKABLE_PROPS = new Item.Properties().m_41491_(TAB_GADGETS).m_41487_(1);
    private static final Function<Block, ? extends BlockItem> DEFAULT_BLOCK_ITEM = b -> new BlockItem(b, GADGET_PROPS);
    private static final Function<Block, ? extends BlockItem> TOOLTIP_BLOCK_ITEM = b -> new BlockTooltipItem(b, GADGET_PROPS);
    private static final Function<Block, ? extends BlockItem> UNSTACKABLE_BLOCK_ITEM = b -> new BlockTooltipItem(b, UNSTACKABLE_PROPS);
    public static final ItemObject<PunjiBlock> punji = BLOCKS.register("punji", () -> new PunjiBlock(TinkerGadgets.builder(Material.f_76300_, SoundType.f_56740_).m_60978_(3.0f).m_60956_(0.4f).m_60955_()), TOOLTIP_BLOCK_ITEM);
    public static final ItemObject<PiggyBackPackItem> piggyBackpack = ITEMS.register("piggy_backpack", () -> new PiggyBackPackItem(new Item.Properties().m_41491_(TAB_GADGETS).m_41487_(16)));
    public static final EnumObject<FrameType, FancyItemFrameItem> itemFrame = ITEMS.registerEnum(FrameType.values(), "item_frame", type -> new FancyItemFrameItem(GADGET_PROPS, (world, pos, dir) -> new FancyItemFrameEntity((Level)world, (BlockPos)pos, (Direction)dir, (FrameType)((Object)type))));
    private static final Item.Properties SLING_PROPS = new Item.Properties().m_41491_(TAB_GADGETS).m_41487_(1).m_41503_(250);
    public static final EnumObject<SlimeType, BaseSlimeSlingItem> slimeSling = new EnumObject.Builder(SlimeType.class).put((Enum)SlimeType.EARTH, (Supplier)ITEMS.register("earth_slime_sling", () -> new EarthSlimeSlingItem(SLING_PROPS))).put((Enum)SlimeType.SKY, (Supplier)ITEMS.register("sky_slime_sling", () -> new SkySlimeSlingItem(SLING_PROPS))).put((Enum)SlimeType.ICHOR, (Supplier)ITEMS.register("ichor_slime_sling", () -> new IchorSlimeSlingItem(SLING_PROPS))).put((Enum)SlimeType.ENDER, (Supplier)ITEMS.register("ender_slime_sling", () -> new EnderSlimeSlingItem(SLING_PROPS))).build();
    public static final ItemObject<GlowBallItem> glowBall = ITEMS.register("glow_ball", GlowBallItem::new);
    public static final ItemObject<EflnBallItem> efln = ITEMS.register("efln_ball", EflnBallItem::new);
    private static final BlockBehaviour.Properties CAKE = TinkerGadgets.builder(Material.f_76287_, SoundType.f_56745_).m_60978_(0.5f);
    public static final EnumObject<SlimeType, FoodCakeBlock> cake = BLOCKS.registerEnum(SlimeType.LIQUID, "cake", type -> new FoodCakeBlock(CAKE, TinkerFood.getCake(type)), UNSTACKABLE_BLOCK_ITEM);
    public static final ItemObject<FoodCakeBlock> magmaCake = BLOCKS.register("magma_cake", () -> new FoodCakeBlock(CAKE, TinkerFood.MAGMA_CAKE), UNSTACKABLE_BLOCK_ITEM);
    private static final Item.Properties THROWABLE_PROPS = new Item.Properties().m_41487_(16).m_41491_(TAB_GADGETS);
    public static final ItemObject<ShurikenItem> quartzShuriken = ITEMS.register("quartz_shuriken", () -> new ShurikenItem(THROWABLE_PROPS, QuartzShurikenEntity::new));
    public static final ItemObject<ShurikenItem> flintShuriken = ITEMS.register("flint_shuriken", () -> new ShurikenItem(THROWABLE_PROPS, FlintShurikenEntity::new));
    public static final RegistryObject<EntityType<FancyItemFrameEntity>> itemFrameEntity = ENTITIES.register("fancy_item_frame", () -> EntityType.Builder.m_20704_(FancyItemFrameEntity::new, (MobCategory)MobCategory.MISC).m_20699_(0.5f, 0.5f).setTrackingRange(10).setUpdateInterval(Integer.MAX_VALUE).setCustomClientFactory((spawnEntity, world) -> new FancyItemFrameEntity((EntityType<? extends FancyItemFrameEntity>)((EntityType)itemFrameEntity.get()), (Level)world)).setShouldReceiveVelocityUpdates(false));
    public static final RegistryObject<EntityType<GlowballEntity>> glowBallEntity = ENTITIES.register("glow_ball", () -> EntityType.Builder.m_20704_(GlowballEntity::new, (MobCategory)MobCategory.MISC).m_20699_(0.25f, 0.25f).setTrackingRange(4).setUpdateInterval(10).setCustomClientFactory((spawnEntity, world) -> new GlowballEntity((EntityType<? extends GlowballEntity>)((EntityType)glowBallEntity.get()), (Level)world)).setShouldReceiveVelocityUpdates(true));
    public static final RegistryObject<EntityType<EflnBallEntity>> eflnEntity = ENTITIES.register("efln_ball", () -> EntityType.Builder.m_20704_(EflnBallEntity::new, (MobCategory)MobCategory.MISC).m_20699_(0.25f, 0.25f).setTrackingRange(4).setUpdateInterval(10).setCustomClientFactory((spawnEntity, world) -> new EflnBallEntity((EntityType<? extends EflnBallEntity>)((EntityType)eflnEntity.get()), (Level)world)).setShouldReceiveVelocityUpdates(true));
    public static final RegistryObject<EntityType<QuartzShurikenEntity>> quartzShurikenEntity = ENTITIES.register("quartz_shuriken", () -> EntityType.Builder.m_20704_(QuartzShurikenEntity::new, (MobCategory)MobCategory.MISC).m_20699_(0.25f, 0.25f).setTrackingRange(4).setUpdateInterval(10).setCustomClientFactory((spawnEntity, world) -> new QuartzShurikenEntity((EntityType<? extends QuartzShurikenEntity>)((EntityType)quartzShurikenEntity.get()), (Level)world)).setShouldReceiveVelocityUpdates(true));
    public static final RegistryObject<EntityType<FlintShurikenEntity>> flintShurikenEntity = ENTITIES.register("flint_shuriken", () -> EntityType.Builder.m_20704_(FlintShurikenEntity::new, (MobCategory)MobCategory.MISC).m_20699_(0.25f, 0.25f).setTrackingRange(4).setUpdateInterval(10).setCustomClientFactory((spawnEntity, world) -> new FlintShurikenEntity((EntityType<? extends FlintShurikenEntity>)((EntityType)flintShurikenEntity.get()), (Level)world)).setShouldReceiveVelocityUpdates(true));
    public static final RegistryObject<PiggyBackPackItem.CarryPotionEffect> carryEffect = MOB_EFFECTS.register("carry", PiggyBackPackItem.CarryPotionEffect::new);

    @SubscribeEvent
    void commonSetup(FMLCommonSetupEvent event) {
        PiggybackCapability.register();
        event.enqueueWork(() -> {
            cake.forEach(block -> ComposterBlock.m_51920_((float)1.0f, (ItemLike)block));
            ComposterBlock.m_51920_((float)1.0f, (ItemLike)((ItemLike)magmaCake.get()));
        });
    }

    @SubscribeEvent
    void gatherData(GatherDataEvent event) {
        if (event.includeServer()) {
            DataGenerator datagenerator = event.getGenerator();
            datagenerator.m_123914_((DataProvider)new GadgetRecipeProvider(datagenerator));
        }
    }
}

